<?php 

/**
 * Footer links detail content block
 *
 * @category   BusinessKing
 * @package    BusinessKing_Footerlinks
 */
class BusinessKing_Footerlinks_Block_Adminhtml_Linksdetail extends Mage_Adminhtml_Block_Template
{
    protected function _construct()
    {
    	$this->setTemplate('footerlinks/linksdetail.phtml');        
    }
    
	/**
     * Retrieve Session Form Key
     *
     * @return string
     */
    public function getFormKey()
    { 
    	return parent::getFormKey();
        //return Mage::getSingleton('core/session')->getFormKey();
    }
    
    public function getFormUrl()
    {
    	return $this->getUrl('adminfooterlinks/adminhtml_linksdetail/save');
    }
    
    public function getFooterLinks($linkId)
    {
    	return Mage::getSingleton('footerlinks/footer')->getFooterLinks($linkId);
    }
    
    public function getParentName($linkId)
    {
    	if ($linkId>0) {
    		$name = Mage::getSingleton('footerlinks/footer')->getParentName($linkId);
    		return ' - '.$name['name'];
    	}
    	else {
    		return '';
    	}
    }
    
    public function getLinkId()
    {
    	$id = $this->getRequest()->getParam('id');
    	if(empty($id)) {
    		$id = 0;
    	}
    	return $id;
    }
}