<?php

class Stream_Giftproduct_Model_System_Config_Source_Product {

    protected $_options;

    public function toOptionArray($isMultiselect = false) {
        if (!$this->_options) {
            $products = Mage::getModel('catalog/product')->getCollection()
                    ->addAttributeToSelect('name')
                    ->addAttributeToSelect('sku')
                    ->addAttributeToFilter('visibility', 1)
                    ->addAttributeToFilter('type_id', array('eq' => 'simple'));
            $this->_options[] = Mage::helper('adminhtml')->__('--Please Select--');
            foreach ($products as $product) {
                $this->_options[$product->getId()] = $product->getName() . ' [' . $product->getSku() . ']';
            }
        }
        return $this->_options;
    }

}
