<?php

class Stream_Giftproduct_Model_Observer {

    public function addGiftProduct($observer) {
        $isGiftProductEnabled = Mage::getStoreConfig('giftproduct/general/enable');
        if ($isGiftProductEnabled) {
            $productId = Mage::getStoreConfig('giftproduct/general/productId');
            $requiredPurchase = Mage::getStoreConfig('giftproduct/general/requiredSubTotal');
            $totals = Mage::getSingleton('checkout/session')->getQuote()->getTotals();
            $subtotal = $totals["subtotal"]->getValue();
            if (Mage::getSingleton('checkout/session')->getGiftItemAdded()) {
                if ($subtotal < $requiredPurchase) {
                    Mage::getSingleton('checkout/session')->setGiftItemAdded(FALSE);
                    $cartHelper = Mage::helper('checkout/cart');
                    $items = $cartHelper->getCart()->getItems();
                    foreach ($items as $item) {
                        if ($item->getProduct()->getId() == $productId) {
                            $cartHelper->getCart()->removeItem($item->getItemId())->save();
                            break;
                        }
                    }
                }
            } else if ($productId && $subtotal >= $requiredPurchase) {
                $this->_addGiftProductInCart($productId);
            }
        }
    }

    private function _addGiftProductInCart($productId) {
        $product = Mage::getModel('catalog/product');
        $product->load($productId);
        if ($product->getId()) {
            $params = array(
                'product' => $productId,
                'qty' => 1
            );
            $cart = Mage::getSingleton('checkout/cart');
            Mage::getSingleton('checkout/session')->setGiftItemAdded(TRUE);
            $cart->addProduct($product, $params);
            $cart->save();
            Mage::getSingleton('checkout/session')->setCartWasUpdated(TRUE);
        }
    }

    public function addGiftProductPrice($observer) {
        $isGiftProductEnabled = Mage::getStoreConfig('giftproduct/general/enable');
        if ($isGiftProductEnabled && Mage::getSingleton('checkout/session')->getGiftItemAdded()) {
            $productId = Mage::getStoreConfig('giftproduct/general/productId');
            if ($productId) {
                $item = $observer->getQuoteItem();
                $parentItem = $item->getParentItem();
                $item = ( $parentItem ? $parentItem : $item );
                if ($productId == $item->getProduct()->getId()) {
                    $item->setCustomPrice(0);
                    $item->setOriginalCustomPrice(0);
                    $item->getProduct()->setIsSuperMode(TRUE);
                }
            }
        }
    }

    public function validateGiftProduct($observer) {
        $isGiftProductEnabled = Mage::getStoreConfig('giftproduct/general/enable');
        if ($isGiftProductEnabled && Mage::getSingleton('checkout/session')->getGiftItemAdded()) {
            $productId = Mage::getStoreConfig('giftproduct/general/productId');
            if ($productId) {
                $product = Mage::getModel('catalog/product')->load($productId);
                if ($product->getId()) {
                    $quote = Mage::getSingleton('checkout/session')->getQuote();
                    $item = $quote->getItemByProduct($product);
                    if ($item && $item->getQty() > 1) {
                        $item->setQty(1);
                    }
                }
            }
        }
    }

    public function reloadGiftProduct($observer) {
        $isGiftProductEnabled = Mage::getStoreConfig('giftproduct/general/enable');
        if ($isGiftProductEnabled && Mage::getSingleton('checkout/session')->getGiftItemAdded()) {
            $productId = Mage::getStoreConfig('giftproduct/general/productId');
            if ($productId) {
                $item = $observer->getQuoteItem();
                if ($productId == $item->getProduct()->getId()) {
                    $this->_addGiftProductInCart($productId);
                }
            }
        }
    }

}