<?php

/**
 * Footer links admin controller
 *
 * @category   BusinessKing
 * @package    BusinessKing_Footerlinks
 */
class BusinessKing_Footerlinks_Adminhtml_LinksdetailController extends Mage_Adminhtml_Controller_Action
{
    public function _initAction()
    {
        $this->loadLayout()
            ->_addBreadcrumb(Mage::helper('adminhtml')->__('Footer Links'), Mage::helper('adminhtml')->__('Footer Links'));           
        return $this;
    }
    
    public function indexAction()
    {
		$this->_initAction()
            ->_setActiveMenu('footerlinks')
            ->_addBreadcrumb(Mage::helper('adminhtml')->__('Footer Links'), Mage::helper('adminhtml')->__('Footer Links'))
            ->_addContent($this->getLayout()->createBlock('footerlinks/adminhtml_linksdetail'))
            ->renderLayout();    	
    }
    
    public function saveAction()
    {     	
    	if ($this->getRequest()->isPost()) {
	    	$action = $this->getRequest()->getPost('action_name');
	    	$label = $this->getRequest()->getPost('label');
	    	$url = $this->getRequest()->getPost('url');
	    	$isActive = $this->getRequest()->getPost('is_active');
	    	$linkData = array(
	    		'name' => str_replace("%20"," ",$label),
	    		'url' => $url,
	    		'is_active' => $isActive
	    	);
	    	if ($action=="add") {
	    		$linkData['parent_id'] = $this->getRequest()->getPost('parent_id');
	    		Mage::getSingleton('footerlinks/footer')->addLink($linkData);
	    		Mage::getSingleton('admin/session')->setData('FooterLinksMsg','Link added successfully');
	    	}   
	    	else {
	    		Mage::getSingleton('footerlinks/footer')->editLink($linkData, $action);
	    		Mage::getSingleton('admin/session')->setData('FooterLinksMsg','Link detail saved successfully');
	    	} 
    	}		
    	$this->_redirect('adminfooterlinks/adminhtml_linksdetail');
    }
    
    public function deleteAction()
    {
    	$id = $this->getRequest()->getParam('id');
    	if (!empty($id)) {
    		Mage::getSingleton('footerlinks/footer')->deleteLink($id);
    		Mage::getSingleton('admin/session')->setData('FooterLinksMsg','Link deleted successfully');
    	}	
    	$this->_redirect('adminfooterlinks/adminhtml_linksdetail');
    }
}